"use client";

import { useEffect, useState } from "react";
import Link from "next/link";
import { Button, Card, CardBody, CardHeader, Container } from "@/components/ui";

export default function PosLivePage({ params }: { params: { token: string } }) {
  const token = params.token;
  const [status, setStatus] = useState<string>("LOADING");
  const [paidTxId, setPaidTxId] = useState<string | null>(null);

  useEffect(() => {
    let alive = true;
    async function poll() {
      try {
        const res = await fetch(`/api/pos/charge-status?token=${encodeURIComponent(token)}`).then((r) => r.json());
        if (!alive) return;
        setStatus(res.status ?? "UNKNOWN");
        setPaidTxId(res.paidTxId ?? null);
      } catch {
        // ignore
      }
    }
    poll();
    const t = setInterval(poll, 1500);
    return () => {
      alive = false;
      clearInterval(t);
    };
  }, [token]);

  return (
    <div className="min-h-screen bg-zinc-50">
      <Container>
        <div className="mx-auto max-w-lg pt-10">
          <Card>
            <CardHeader title="Live POS status" subtitle="Auto-refreshing" />
            <CardBody>
              <div className="text-sm text-zinc-600">Charge token</div>
              <div className="mt-1 break-all text-xs font-medium">{token}</div>
              <div className="mt-4 text-sm text-zinc-600">Status</div>
              <div className="mt-1 text-2xl font-semibold">{status}</div>
              {paidTxId ? (
                <div className="mt-2 text-xs text-zinc-600">Paid Tx: {paidTxId}</div>
              ) : null}
              <div className="mt-6 flex gap-2">
                <Button asChild variant="secondary">
                  <Link href={`/merchant/pos/qr/${token}`}>Back</Link>
                </Button>
                <Button asChild>
                  <Link href="/merchant/pos">POS</Link>
                </Button>
              </div>
            </CardBody>
          </Card>
        </div>
      </Container>
    </div>
  );
}
